using System;
using System.Collections;
using System.ComponentModel;
using System.Data;
using System.Data.SqlClient;
using System.Drawing;
using System.Windows.Forms;
using Microsoft.Reporting.WinForms;
using System.Reflection;
using System.IO;


namespace gov.va.med.vbecs.GUI
{
	/// <summary>
	/// Class FrmPrintCautionTagByUnit
	/// </summary>
	public class FrmPrintCautionTagByUnit : gov.va.med.vbecs.GUI.VbecsBaseForm
	{
		private BOL.Patient _patient;
		private BOL.CautionTag _cautionTag;

		private System.Windows.Forms.Button btnCancel;
		private System.Windows.Forms.GroupBox grpImage;
		private System.Windows.Forms.PictureBox picImage;
		private System.Windows.Forms.CheckBox cbSearchByPatient;
		private gov.va.med.vbecs.GUI.controls.BloodUnitSelectorVertical bloodUnitSelectorVertical1;
		private gov.va.med.vbecs.GUI.controls.BloodUnitDetailsTab bloodUnitDetailsTab1;
		private System.Windows.Forms.GroupBox grpPrint;
		private gov.va.med.vbecs.GUI.controls.VbecsButton btnPrintTag;
		private gov.va.med.vbecs.GUI.controls.VbecsButton btnPrintForm;
		private gov.va.med.vbecs.GUI.controls.VbecsButton btnPrintBoth;
		private System.Windows.Forms.PrintDialog printDialog1;
		private System.ComponentModel.IContainer components = null;

		/// <summary>
		/// Constructor
		/// </summary>
		public FrmPrintCautionTagByUnit()
		{
			// This call is required by the Windows Form Designer.
			InitializeComponent();

			SetComponentProperties();
		}

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if (components != null) 
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
            System.ComponentModel.ComponentResourceManager resources = new System.ComponentModel.ComponentResourceManager(typeof(FrmPrintCautionTagByUnit));
            this.cbSearchByPatient = new System.Windows.Forms.CheckBox();
            this.btnCancel = new System.Windows.Forms.Button();
            this.grpImage = new System.Windows.Forms.GroupBox();
            this.picImage = new System.Windows.Forms.PictureBox();
            this.bloodUnitSelectorVertical1 = new gov.va.med.vbecs.GUI.controls.BloodUnitSelectorVertical();
            this.bloodUnitDetailsTab1 = new gov.va.med.vbecs.GUI.controls.BloodUnitDetailsTab();
            this.grpPrint = new System.Windows.Forms.GroupBox();
            this.btnPrintBoth = new gov.va.med.vbecs.GUI.controls.VbecsButton();
            this.btnPrintForm = new gov.va.med.vbecs.GUI.controls.VbecsButton();
            this.btnPrintTag = new gov.va.med.vbecs.GUI.controls.VbecsButton();
            this.printDialog1 = new System.Windows.Forms.PrintDialog();
            ((System.ComponentModel.ISupportInitialize)(this.errError)).BeginInit();
            this.grpImage.SuspendLayout();
            ((System.ComponentModel.ISupportInitialize)(this.picImage)).BeginInit();
            this.grpPrint.SuspendLayout();
            this.SuspendLayout();
            // 
            // vbecsLogo1
            // 
            this.vbecsLogo1.Size = new System.Drawing.Size(588, 30);
            this.vbecsLogo1.TabIndex = 5;
            this.vbecsLogo1.Title = "Print Unit Caution Tag and Transfusion Record Form";
            // 
            // lblRequiredField
            // 
            this.lblRequiredField.Location = new System.Drawing.Point(0, 363);
            this.lblRequiredField.TabIndex = 7;
            // 
            // cbSearchByPatient
            // 
            this.cbSearchByPatient.Location = new System.Drawing.Point(60, 336);
            this.cbSearchByPatient.Name = "cbSearchByPatient";
            this.cbSearchByPatient.Size = new System.Drawing.Size(120, 16);
            this.cbSearchByPatient.TabIndex = 3;
            this.cbSearchByPatient.Text = "Search by &Patient";
            this.cbSearchByPatient.CheckedChanged += new System.EventHandler(this.checkBox4_CheckedChanged);
            // 
            // btnCancel
            // 
            this.btnCancel.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
            this.btnCancel.DialogResult = System.Windows.Forms.DialogResult.Cancel;
            this.btnCancel.ImageAlign = System.Drawing.ContentAlignment.MiddleLeft;
            this.btnCancel.Location = new System.Drawing.Point(508, 352);
            this.btnCancel.Name = "btnCancel";
            this.btnCancel.Size = new System.Drawing.Size(75, 23);
            this.btnCancel.TabIndex = 4;
            this.btnCancel.Text = "&Cancel";
            this.btnCancel.Click += new System.EventHandler(this.btnCancel_Click);
            // 
            // grpImage
            // 
            this.grpImage.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
            | System.Windows.Forms.AnchorStyles.Left)));
            this.grpImage.Controls.Add(this.picImage);
            this.grpImage.Location = new System.Drawing.Point(4, 32);
            this.grpImage.Name = "grpImage";
            this.grpImage.Size = new System.Drawing.Size(52, 304);
            this.grpImage.TabIndex = 6;
            this.grpImage.TabStop = false;
            // 
            // picImage
            // 
            this.picImage.Image = ((System.Drawing.Image)(resources.GetObject("picImage.Image")));
            this.picImage.Location = new System.Drawing.Point(4, 12);
            this.picImage.Name = "picImage";
            this.picImage.Size = new System.Drawing.Size(45, 45);
            this.picImage.SizeMode = System.Windows.Forms.PictureBoxSizeMode.AutoSize;
            this.picImage.TabIndex = 0;
            this.picImage.TabStop = false;
            // 
            // bloodUnitSelectorVertical1
            // 
            this.bloodUnitSelectorVertical1.AdditionalSearchCriteria = gov.va.med.vbecs.Common.AdditionalBloodUnitSearchCriteria.None;
            this.bloodUnitSelectorVertical1.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((byte)(0)));
            this.bloodUnitSelectorVertical1.Location = new System.Drawing.Point(60, 32);
            this.bloodUnitSelectorVertical1.Name = "bloodUnitSelectorVertical1";
            this.bloodUnitSelectorVertical1.Size = new System.Drawing.Size(258, 304);
            this.bloodUnitSelectorVertical1.TabIndex = 0;
            this.bloodUnitSelectorVertical1.SearchBtnClick += new System.EventHandler(this.bloodUnitSelectorVertical1_SearchBtnClick);
            this.bloodUnitSelectorVertical1.ClearBtnClick += new System.EventHandler(this.bloodUnitSelectorVertical1_ClearBtnClick);
            this.bloodUnitSelectorVertical1.UnitUpdated += new System.EventHandler(this.bloodUnitSelectorVertical1_UnitUpdated);
            // 
            // bloodUnitDetailsTab1
            // 
            this.bloodUnitDetailsTab1.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
            | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.bloodUnitDetailsTab1.BloodUnit = null;
            this.bloodUnitDetailsTab1.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((byte)(0)));
            this.bloodUnitDetailsTab1.Location = new System.Drawing.Point(324, 36);
            this.bloodUnitDetailsTab1.Name = "bloodUnitDetailsTab1";
            this.bloodUnitDetailsTab1.Size = new System.Drawing.Size(260, 184);
            this.bloodUnitDetailsTab1.TabIndex = 1;
            // 
            // grpPrint
            // 
            this.grpPrint.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.grpPrint.Controls.Add(this.btnPrintBoth);
            this.grpPrint.Controls.Add(this.btnPrintForm);
            this.grpPrint.Controls.Add(this.btnPrintTag);
            this.hlphelpChm.SetHelpKeyword(this.grpPrint, "Print_Unit_Caution_Tag_&_Transfusion_Record_Form.htm");
            this.hlphelpChm.SetHelpNavigator(this.grpPrint, System.Windows.Forms.HelpNavigator.Topic);
            this.grpPrint.Location = new System.Drawing.Point(324, 224);
            this.grpPrint.Name = "grpPrint";
            this.hlphelpChm.SetShowHelp(this.grpPrint, true);
            this.grpPrint.Size = new System.Drawing.Size(260, 112);
            this.grpPrint.TabIndex = 2;
            this.grpPrint.TabStop = false;
            // 
            // btnPrintBoth
            // 
            this.btnPrintBoth.EnabledButton = false;
            this.btnPrintBoth.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((byte)(0)));
            this.btnPrintBoth.Image = ((System.Drawing.Image)(resources.GetObject("btnPrintBoth.Image")));
            this.btnPrintBoth.Location = new System.Drawing.Point(12, 76);
            this.btnPrintBoth.Name = "btnPrintBoth";
            this.btnPrintBoth.Size = new System.Drawing.Size(244, 24);
            this.btnPrintBoth.TabIndex = 2;
            this.btnPrintBoth.Click += new System.EventHandler(this.btnPrintBoth_Click);
            // 
            // btnPrintForm
            // 
            this.btnPrintForm.EnabledButton = false;
            this.btnPrintForm.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((byte)(0)));
            this.btnPrintForm.Image = ((System.Drawing.Image)(resources.GetObject("btnPrintForm.Image")));
            this.btnPrintForm.Location = new System.Drawing.Point(12, 48);
            this.btnPrintForm.Name = "btnPrintForm";
            this.btnPrintForm.Size = new System.Drawing.Size(244, 24);
            this.btnPrintForm.TabIndex = 1;
            this.btnPrintForm.Click += new System.EventHandler(this.btnPrintForm_Click);
            // 
            // btnPrintTag
            // 
            this.btnPrintTag.EnabledButton = false;
            this.btnPrintTag.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((byte)(0)));
            this.btnPrintTag.Image = ((System.Drawing.Image)(resources.GetObject("btnPrintTag.Image")));
            this.btnPrintTag.Location = new System.Drawing.Point(12, 20);
            this.btnPrintTag.Name = "btnPrintTag";
            this.btnPrintTag.Size = new System.Drawing.Size(244, 24);
            this.btnPrintTag.TabIndex = 0;
            this.btnPrintTag.Click += new System.EventHandler(this.btnPrintTag_Click);
            // 
            // FrmPrintCautionTagByUnit
            // 
            this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
            this.CancelButton = this.btnCancel;
            this.ClientSize = new System.Drawing.Size(588, 377);
            this.Controls.Add(this.grpPrint);
            this.Controls.Add(this.bloodUnitDetailsTab1);
            this.Controls.Add(this.bloodUnitSelectorVertical1);
            this.Controls.Add(this.grpImage);
            this.Controls.Add(this.btnCancel);
            this.Controls.Add(this.cbSearchByPatient);
            this.hlphelpChm.SetHelpKeyword(this, "Print_Unit_Caution_Tag_&_Transfusion_Record_Form.htm");
            this.hlphelpChm.SetHelpNavigator(this, System.Windows.Forms.HelpNavigator.Topic);
            this.MinimumSize = new System.Drawing.Size(596, 404);
            this.Name = "FrmPrintCautionTagByUnit";
            this.RequiredFieldsLabel = true;
            this.hlphelpChm.SetShowHelp(this, true);
            this.Text = "VBECS - Print Unit Caution Tag and Transfusion Record Form";
            this.KeyDownSpeakMessage += new gov.va.med.vbecs.GUI.VbecsBaseForm.KeyDownSpeakMessageEventHandler(this.FrmPrintCautionTagByUnit_KeyDownSpeakMessage);
            this.Controls.SetChildIndex(this.vbecsLogo1, 0);
            this.Controls.SetChildIndex(this.lblRequiredField, 0);
            this.Controls.SetChildIndex(this.cbSearchByPatient, 0);
            this.Controls.SetChildIndex(this.btnCancel, 0);
            this.Controls.SetChildIndex(this.grpImage, 0);
            this.Controls.SetChildIndex(this.bloodUnitSelectorVertical1, 0);
            this.Controls.SetChildIndex(this.bloodUnitDetailsTab1, 0);
            this.Controls.SetChildIndex(this.grpPrint, 0);
            ((System.ComponentModel.ISupportInitialize)(this.errError)).EndInit();
            this.grpImage.ResumeLayout(false);
            this.grpImage.PerformLayout();
            ((System.ComponentModel.ISupportInitialize)(this.picImage)).EndInit();
            this.grpPrint.ResumeLayout(false);
            this.ResumeLayout(false);
            this.PerformLayout();

		}
		#endregion


		#region methods


        /// <summary>
        /// Create the locks, returns false if they fail.. Defect 279469
        /// </summary>
        /// <returns></returns>
        private bool GenerateLocks()
        {
            this.ReleaseLocks();    //get rid of any existing locks first - unitid/product dont disable after selecting a unit.. bleh

            this.LockController.RecordGuids.Add(this.bloodUnitSelectorVertical1.SelectedBloodUnit.BloodUnitStatus.BloodUnitStatusGuid);

            if (_patient != null)
            {
                BOL.OrderedUnit tmpOU = new BOL.OrderedUnit(this.bloodUnitSelectorVertical1.SelectedBloodUnit.BloodUnitGuid, this._patient.PatientGuid);
                this.LockController.RecordGuids.Add(tmpOU.OrderedUnitGuid);
                BOL.OrderedComponent tmpOC = new BOL.OrderedComponent(tmpOU.OrderedComponentGuid);
                if (tmpOC.SpecimenIdentified)
                {
                    Guid specimenGuid = tmpOC.GetSpecimen().SpecimenGuid;
                    this.LockController.RecordGuids.Add(specimenGuid);
                }
            }

            return (this.SetLocks());
        }

		private void SetComponentProperties()
		{
			// CR 2693
			// hlpHelp
			// 
			this.hlpHelp.HelpNamespace = Environment.CurrentDirectory+"\\VBECS.chm";
			// 
			// hlphelpChm
			// 
			this.hlphelpChm.HelpNamespace = Environment.CurrentDirectory+"\\VBECS.chm";
			this.SetThisHelpFile(this, Common.StrRes.HelpFiles.UC044.FrmPrintCautionTagByUnit());
			this.SetThisHelpFile(this.grpPrint, Common.StrRes.HelpFiles.UC044.FrmPrintCautionTagByUnit());
			//
			this.btnPrintBoth.Text = "Print &Both";
			this.btnPrintForm.Text = "Print Transfusion Record &Form";
			this.btnPrintTag.Text = "Print Unit Caution &Tag";
			//
			this.btnPrintTag.SetToolTip(Common.StrRes.Tooltips.UC043.ChooseUnit().ResString);
			this.btnPrintForm.SetToolTip(Common.StrRes.Tooltips.UC043.ChooseUnit().ResString);
			this.btnPrintBoth.SetToolTip(Common.StrRes.Tooltips.UC043.ChooseUnit().ResString);

            this.LockController.LockFunction = Common.LockFunctions.UC043PrintUnitCautionTag;       //Defect 279469
		}

		private BOL.Patient GetPatient(Guid bloodUnitGUID)
		{
			ArrayList patients = BOL.CautionTag.GetPatients(bloodUnitGUID);
			if (patients.Count == 1)
			{
				return (BOL.Patient) patients[0];
			}
			else if (patients.Count > 1)
			{
				DlgPrintCautionTagChoosePatient dlg = new DlgPrintCautionTagChoosePatient(patients);
				DialogResult result = dlg.ShowDialog(this);
				if (result == DialogResult.OK)
				{
					return dlg.Patient;
				}
				else
				{
					GuiMessenger.ShowMessageBox(Common.StrRes.InfoMsg.UC043.NoPatient());
					this.EnableDisableButtons(false, Common.StrRes.InfoMsg.UC043.NoPatient().ResString);
				}
			}
			else
			{
				GuiMessenger.ShowMessageBox(Common.StrRes.InfoMsg.UC043.NoAssignments());
				this.EnableDisableButtons(false, Common.StrRes.InfoMsg.UC043.NoAssignments().ResString);
			}
			return null;
		}

		/// <summary>
		/// Enables or disables all of the print buttons and sets the tooltips
		/// </summary>
		/// <param name="enable"></param>
		/// <param name="toolTip"></param>
		private void EnableDisableButtons(bool enable, string toolTip)
		{
			this.btnPrintTag.EnabledButton = enable;
			this.btnPrintForm.EnabledButton = enable;
			this.btnPrintBoth.EnabledButton = enable;
			this.btnPrintTag.SetToolTip(toolTip);
			this.btnPrintForm.SetToolTip(toolTip);
			this.btnPrintBoth.SetToolTip(toolTip);
		}

		private void PrintBtrf()
		{
			if (!_cautionTag.GenerateExceptionReport()) 
			{
				GuiMessenger.ShowMessageBox(Common.StrRes.SysErrMsg.UC043.PrinterProblem());
				return;
			}

			// BR_43.13
			if (!Common.LogonUser.PrintedTags.ContainsKey(_cautionTag.BloodUnit.BloodUnitGuid))
			{	
				Common.LogonUser.PrintedTags.Add(_cautionTag.BloodUnit.BloodUnitGuid, _cautionTag.Patient.PatientGuid);
			}

			// Now, send to printer
			System.Drawing.Printing.PrinterSettings settings = new System.Drawing.Printing.PrinterSettings();
			printDialog1.PrinterSettings = settings;
			if (printDialog1.ShowDialog(this) == DialogResult.OK)
			{
                ReportDataSource reportSourceMain = new ReportDataSource();
                reportSourceMain.Name = "BTRFDataSet";
                reportSourceMain.Value = _cautionTag.GetBtrfDataSet().Tables[0];

                Assembly assembly = Assembly.LoadFrom("Reports.dll");
                Stream stream = assembly.GetManifestResourceStream("gov.va.med.vbecs.reports.BloodTransfusionRecordForm.BloodTransfusionRecordForm.rdlc");

                LocalReport report = new LocalReport();
                report.DataSources.Add(reportSourceMain);
                report.LoadReportDefinition(stream);
                report.DisplayName = "BTRF";

			    using (var reportPrinter = new BOL.VbecsReportPrinter(settings, false, report))
			    {
			        reportPrinter.Print();
			    }
			    // CR 3369
                GuiMessenger.ShowMessageBox(Common.StrRes.InfoMsg.UC043.PrintSuccess());
			}
		}

		#endregion


		#region events

		private void checkBox4_CheckedChanged(object sender, System.EventArgs e)
		{
			FrmPrintCautionTagByPatient frm = new FrmPrintCautionTagByPatient();
			frm.Show();
			this.Close();
		}

		private void bloodUnitSelectorVertical1_SearchBtnClick(object sender, System.EventArgs e)
		{
			// New unit, so reset patient
			_patient = null;
		
			DataTable dtUnits = BOL.CautionTag.GetUnitsForDisplay();

			if (dtUnits.Rows.Count > 0)
			{
				//
				DlgSelectBloodUnits unitSelector = new DlgSelectBloodUnits(dtUnits, this.bloodUnitSelectorVertical1.EnteredEyeReadableUnitId, this.bloodUnitSelectorVertical1.EnteredUnitProductCode);
				unitSelector.TitleBarText	= "VBECS - Select Unit for Printing";
				unitSelector.LogoBarText	= "Select Unit for Printing";
				unitSelector.MultiSelect	= false;
				unitSelector.ShowDialog(this);
				//
				if (unitSelector.DialogResult == DialogResult.OK)
				{
					if (unitSelector.SelectedUnits.Rows.Count == 1)
					{
						DataRow dr = unitSelector.SelectedUnits.Rows[0];
						BOL.BloodUnit bloodUnit = new BOL.BloodUnit( (Guid) dr[Common.VbecsTables.BloodUnit.BloodUnitGuid], (Guid) dr[Common.VbecsTables.BloodUnit.BloodUnitGuid] );
						this.bloodUnitSelectorVertical1.DisplayBloodUnit(dr[Common.VbecsTables.BloodUnit.EyeReadableUnitId].ToString(), dr[Common.DatabaseConstants.ArtificialColumnNames.FullProductCode].ToString());
					}
				}
			}
			else
			{
				GuiMessenger.ShowMessageBox(Common.StrRes.InfoMsg.UC043.NoValidUnits());
			}
		}

		private void bloodUnitSelectorVertical1_UnitUpdated(object sender, System.EventArgs e)
		{
			if (_patient==null)
			{
				_patient = GetPatient(this.bloodUnitSelectorVertical1.SelectedBloodUnit.BloodUnitGuid);
				if (_patient!=null && this.GenerateLocks())  //Defect 279469
				{
					_cautionTag = new BOL.CautionTag(this.bloodUnitSelectorVertical1.SelectedBloodUnit, _patient, ThisUser, false);
					
					// everything in fine!
					if (!_cautionTag.OverrideRequired && _cautionTag.PrintOK == true && _cautionTag.Message.Length == 0)
					{
						this.EnableDisableButtons(true, string.Empty);
					}
					else
					{
						// everything is bad
						if (!_cautionTag.PrintOK)
						{
							// CR2195: Display a MessageBox when a unit cannot be printed
							GuiMessenger.ShowMessageBox(Common.StrRes.SysErrMsg.Common.Dynamic(_cautionTag.Message));
							// CR2195 end
							this.EnableDisableButtons(false, _cautionTag.Message);
						}
						else
						{
							if (_cautionTag.OverrideRequired)
							{
								GuiMessenger.ShowMessageBox(Common.StrRes.InfoMsg.UC043.Warnings("\n\n" + _cautionTag.Message + "\n"));
								// Get override comment
								DlgOverrideComment dlg = new DlgOverrideComment("VBECS - Comment is needed", "Please enter a comment to override warnings", "UI", Common.StrRes.HelpFiles.UC044.FrmPrintCautionTagByUnit().ResString);
								DialogResult result = dlg.ShowDialog(this);	 
								if (result == DialogResult.OK)
								{
									_cautionTag.OverrideComment = dlg.Comment;
									this.EnableDisableButtons(true, string.Empty);
								}
								else
								{
									this.EnableDisableButtons(false, _cautionTag.Message);
								}
							}
							else
							{
								GuiMessenger.ShowMessageBox(Common.StrRes.InfoMsg.UC043.Informational("\n\n" + _cautionTag.Message + "\n"));
								this.EnableDisableButtons(true, string.Empty);
							}
						}
					}
					this.bloodUnitDetailsTab1.BloodUnit = this.bloodUnitSelectorVertical1.SelectedBloodUnit;
				}
				_patient = null;
			}
		}

		private void btnCancel_Click(object sender, System.EventArgs e)
		{
			this.Close();
		}

		private void btnPrintTag_Click(object sender, System.EventArgs e)
		{			
			if (Common.LogonUser.PrintThreadCT != null && Common.LogonUser.PrintThreadCT.IsAlive && _cautionTag.EmergencyIssue)
			{
				Common.LogonUser.PrintThreadCT.Abort();
			}
		
			// blocking until printer becomes available
			while (Common.LogonUser.PrintThreadCT != null && Common.LogonUser.PrintThreadCT.IsAlive);

			try
			{
				if (_cautionTag.Print(Common.Print.CautionTag))
				{
					GuiMessenger.ShowMessageBox(Common.StrRes.InfoMsg.UC043.PrintSuccess());
				}
				else
				{
					GuiMessenger.ShowMessageBox(Common.StrRes.SysErrMsg.UC043.PrinterProblem());
				}
			}
			catch(BOL.BusinessObjectException)
			{
				GuiMessenger.ShowMessageBox(Common.StrRes.InfoMsg.UC003.CautionTagPrinterNotAvailable());
			}
			catch (System.Net.Sockets.SocketException)
			{
				GuiMessenger.ShowMessageBox(Common.StrRes.InfoMsg.UC003.CautionTagPrinterNotAvailable());
			}	
		}

		private void btnPrintForm_Click(object sender, System.EventArgs e)
		{
			if (Common.LogonUser.PrintThreadBTRF != null && Common.LogonUser.PrintThreadBTRF.IsAlive && _cautionTag.EmergencyIssue)
			{
				Common.LogonUser.PrintThreadBTRF.Abort();
			}

			// blocking until printer becomes available
			while (Common.LogonUser.PrintThreadBTRF != null && Common.LogonUser.PrintThreadBTRF.IsAlive);

			PrintBtrf();
		}

		private void btnPrintBoth_Click(object sender, System.EventArgs e)
		{
			if (Common.LogonUser.PrintThreadCT != null && Common.LogonUser.PrintThreadCT.IsAlive && _cautionTag.EmergencyIssue)
			{
				Common.LogonUser.PrintThreadCT.Abort();
			}
			if (Common.LogonUser.PrintThreadBTRF != null && Common.LogonUser.PrintThreadBTRF.IsAlive && _cautionTag.EmergencyIssue)
			{
				Common.LogonUser.PrintThreadBTRF.Abort();
			}

			// blocking until printer becomes available
			while (Common.LogonUser.PrintThreadCT != null && Common.LogonUser.PrintThreadCT.IsAlive &&
				Common.LogonUser.PrintThreadBTRF != null && Common.LogonUser.PrintThreadBTRF.IsAlive);

			PrintBtrf();
			
			try
			{
				if (_cautionTag.Print(Common.Print.CautionTag))
				{
					GuiMessenger.ShowMessageBox(Common.StrRes.InfoMsg.UC043.PrintSuccess());
				}
				else
				{
					GuiMessenger.ShowMessageBox(Common.StrRes.SysErrMsg.UC043.PrinterProblem());
				}
			}
			catch(BOL.BusinessObjectException)
			{
				GuiMessenger.ShowMessageBox(Common.StrRes.InfoMsg.UC003.CautionTagPrinterNotAvailable());
			}
			catch (System.Net.Sockets.SocketException)
			{
				GuiMessenger.ShowMessageBox(Common.StrRes.InfoMsg.UC003.CautionTagPrinterNotAvailable());
			}	
		}

		private void bloodUnitSelectorVertical1_ClearBtnClick(object sender, System.EventArgs e)
		{
			EnableDisableButtons(false, Common.StrRes.Tooltips.UC043.ChooseUnit().ResString);
			this.bloodUnitDetailsTab1.BloodUnit = null;
            this.ReleaseLocks();        //Defect 279469
		}

		#endregion
	
		/// <summary>
		/// **** 508 Compliance ***
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void FrmPrintCautionTagByUnit_KeyDownSpeakMessage(object sender, System.EventArgs e)
		{
			string textToSpeak = "";

			if (this.btnPrintBoth.EnabledButton == false)
			{
				textToSpeak = this.btnPrintBoth.GetToolTip();
			}

			if (this.btnPrintForm.EnabledButton == false)
			{
				if (textToSpeak != "")
					textToSpeak += "\n";
				if (textToSpeak.IndexOf(this.btnPrintForm.GetToolTip()) == -1)
					textToSpeak += this.btnPrintForm.GetToolTip();
			}

			if (this.btnPrintTag.EnabledButton == false)
			{
				if (textToSpeak != "")
					textToSpeak += "\n";
				if (textToSpeak.IndexOf(this.btnPrintForm.GetToolTip()) == -1)
					textToSpeak += this.btnPrintForm.GetToolTip();
			}

			this.SpeakMessage( textToSpeak );		
		}
	}
}

